#!/usr/bin/env python3
import pathlib
import time
import os
import sys

if __name__ == "__main__":
    palettes = [
        "sleep_crafted/blazer_palette",
        "sleep_crafted/borland_palette",
        "sleep_crafted/c64_palette",
        "sleep_crafted/chalkboard_palette",
        "sleep_crafted/chalk_palette",
        "sleep_crafted/dracula_palette",
        "sleep_crafted/gruvbox_palette",
        "sleep_crafted/japanesque_palette",
        "sleep_crafted/solarized-dark_palette",
        "sleep_crafted/vs-code-dark+_palette"
    ]
    for palette in palettes:
        map_file = pathlib.Path("dreadbase_fix1_gd_20231114_1849.map").read_text()
        pathlib.Path("./dreadbase_fix1_gd.map").write_text(map_file.replace("sleep_crafted/solarized-dark_palette", palette))
        print(os.popen("clear").read())
        print("Palette set to " + palette.replace("sleep_crafted/", ""))
        time.sleep(5)
